#ifndef CANVAS_H
#define CANVAS_H

#include "GlobalDefines.h"
#include "Circuit.h"

#define CANVAS_GATE_X_SPACING 240
#define CANVAS_GATE_Y_SPACING 20

#define COLOR_WIRE_REGION_OUTLINE 255,0,0,200
#define COLOR_WIRE_REGION_V 255,0,0,50
#define COLOR_WIRE_REGION_H	0,0,255,50

class Canvas : public QGraphicsView
{
        Q_OBJECT
    public:
        Canvas(QWidget *parent = 0);

        QSize minimumSizeHint() const;
        QSize sizeHint() const;

        void drawCircuit(Circuit *circuit);

    signals:
        void updateZoomSlider(int value);
        void updateStatus(QString status);

    public slots:
        void zoomCanvas(int);

    protected:
#ifndef QT_NO_WHEELEVENT
        virtual void wheelEvent(QWheelEvent *event);
#endif
        virtual void mousePressEvent(QMouseEvent *event);
        virtual void mouseMoveEvent(QMouseEvent *event);
        virtual void mouseReleaseEvent(QMouseEvent *event);

    private:
        QGraphicsScene *scene;
        QGraphicsTextItem *resolution;

        int zoomLevel;

        Circuit *circuit;

        bool _pan;
        int _panStartX, _panStartY;

#ifdef _DEBUG
        QPen debugPen;
#endif
};

#endif // CANVAS_H
